	% Example 5.9
	clear all
	close all
	
	wcT = 0.25;
	Amin = 40;
	N = 32;
	n = 0:N;
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	
	% Kaiser
	a = 0.5842*((Amin-21)^0.4)+0.07886*(Amin-21)
	B0 = 1;
	for r=1:20
		B0 = B0+(((a/2)^r)/FACTORIAL(r))^2;
	end
	for k=-N/2:N/2;
		x = a*sqrt(1-(2*k/N)^2);
		B1 = 1;
		for r=1:20
			B1 = B1+(((x/2)^r)/FACTORIAL(r))^2;
		end
		win(k+N/2+1) = B1/B0;
	end
	h = fir1(N,wcT,win);
	wT = linspace(0, pi, 2000);
	Win = freqz(win, 1, wT);
	H = freqz(h, 1, wT);
	Mag  = H_2_MAG(H);
	
	subplot('position', [0.10 0.4 0.86 0.5]);
	plot(wT, H_2_MAG(H),'--', 'linewidth', 2)
	axis([0 pi -80 0]);
	hold on
	 
	% MPR OBS REMEZ
%	[N,f0, m, W] = remezord([0.18 0.32], [1 0], [0.01 0.01],2)
	[N,f0, m, W] = HERRMANN_LP_FIR_ORDER([0.18 0.32]*pi, [0.01 0.01])
%	h = remez(32, f0, m, W);
[h, Err] = REMEZ_FIR(N, f0, m, W, 'm');
	H = freqz(h, 1, wT);
	Mag = H_2_MAG(H);	
	
	plot(wT, H_2_MAG(H), 'linewidth', 2)
	set(gca,'FontName','times','FontSize',16)
	
	ylabel('{|\itH}({\ite^j^\omega^T})|','FontName', fn,'FontSize',fs);	
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};
	xtick(ax,lab);
	grid on;	
	text(1.1, -20,'Kaiser window','FontName',fn,'FontSize',fs);
	text(2.0, -38,'Parks-McCellan-Rabiner','FontName',fn,'FontSize',fs);
	line([1.5 1.75], [-25 -54], 'linewidth', 2)
	
